<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/functions.php';


$L = load_lang();
$view = $_GET['view'] ?? 'register';
$flashes = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($view === 'register') {
        $flashes = process_register($L);
    } elseif ($view === 'login') {
        $flashes = process_login($L);
    }
}
?>
<!doctype html>
<html lang="<?= get_lang() ?>" dir="<?= dir_attr() ?>">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= e($L['app_title']) ?></title>

<link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;600;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.fontcdn.ir/Font/Persian/IRANSansX/IRANSansX.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css"/>
<link rel="stylesheet" href="../../template/main/css/fonts.css">
<link rel="stylesheet" href="../../template/main/css/animate.css">
<?php if (get_lang() === 'fa'): ?>
  <link rel="stylesheet" href="../../template/main/css/rtl.css">
<?php else: ?>
  <link rel="stylesheet" href="../../template/main/css/ltr.css">
<?php endif; ?>


<link rel="stylesheet" href="../../template/main/css/responsive.css">
<link rel="stylesheet" href="../../template/main/css/style.css">
<link rel="stylesheet" href="../../template/main/css/main.css">
<link rel="stylesheet" href="../../template/main/css/popup.css">
</head>
<body class="<?= align_class() ?> <?= lang_class() ?>">

<div class="bg-animated"></div>

<div class="container glass fade-in">
  <div class="lang-title"> 
    <div class="lang-switch">
      <a href="?lang=fa&view=<?=$view?>">🇮🇷</a>
      <a href="?lang=en&view=<?=$view?>">🇬🇧</a>
    </div>
    <h1><i class="fa-solid fa-user-pen"></i> <?=e($L[$view==='register'?'register_title':'login_title'])?></h1>
  </div>

  <?php if (!empty($flashes)): ?>
    <?php foreach ($flashes as $type => $msg): ?>
      <div class="popup-overlay">
        <div class="popup <?= e($type) ?>">
          <span class="popup-close">&times;</span>
          <p><?= e($msg) ?></p>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

  <div class="tabs">
    <a class="tab <?= $view==='register'?'active':'' ?>" href="?view=register&lang=<?= e(get_lang()) ?>">
      <i class="fa-solid fa-user-plus"></i> <?= e($L['toggle_to_register']) ?>
    </a>
    <a class="tab <?= $view==='login'?'active':'' ?>" href="?view=login&lang=<?= e(get_lang()) ?>">
      <i class="fa-solid fa-right-to-bracket"></i> <?= e($L['toggle_to_login']) ?>
    </a>
  </div>

  <?php 
    if ($view === 'register') {
        require __DIR__ . '/register.php';
    } else {
        require __DIR__ . '/login.php';
    }
  ?>
</div>

<script src="../template/main/js/popup.js"></script>
</body>
</html>
