import { closeAllActionDivs } from './utils.js';

export function initializeAccordions() {
  // آکاردئونی کردن سطح‌ها
  document.querySelectorAll('.level1,.level2').forEach(el => {
    el.addEventListener('click', () => {
      const targetId = el.dataset.target;
      const target = document.getElementById(targetId);
      if (!target) return;
      
      if (el.classList.contains('level1')) {
        document.querySelectorAll('.level1').forEach(l => {
          if (l !== el) {
            const t = document.getElementById(l.dataset.target);
            if (t) t.classList.add('hidden');
          }
        });
      }
      
      if (el.classList.contains('level2')) {
        document.querySelectorAll('.level2').forEach(l => {
          if (l !== el) {
            const t = document.getElementById(l.dataset.target);
            if (t) t.classList.add('hidden');
          }
        });
      }
      
      target.classList.toggle('hidden');
    });
  });
}