import { showMessage } from './messages.js';
import { getOpenTabs } from './utils.js';

export function initializeFormSubmissions() {
  // ارسال فرم افزودن سطح 1
  const addLevel1Form = document.getElementById('add_level1');
  if (addLevel1Form) {
    addLevel1Form.addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('parentID', ''); // خالی => سطح 1
      
      submitForm('add_category.php', formData, () => {
        this.reset(); // فرم خالی بشه
        document.getElementById('toggle').checked = false; // فرم بسته بشه
        showMessage('مجموعه جدید با موفقیت ذخیره شد', 'success');
        location.reload();
      });
    });
  }

  // ارسال فرم ویرایش دسته
  document.querySelectorAll('.edit-form').forEach(form => {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('catID', this.dataset.id);

      submitForm('edit_category.php', formData, () => {
        showMessage('ویرایش با موفقیت انجام شد', 'success');
        location.reload();
      });
    });
  });

  // ارسال فرم افزودن زیرمجموعه
  document.querySelectorAll('.add-form[data-parent]').forEach(form => {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('parentID', this.dataset.parent);

      submitForm('add_category.php', formData, () => {
        this.reset(); // فرم خالی بشه
        showMessage('زیرمجموعه با موفقیت اضافه شد', 'success');
        location.reload();
      });
    });
  });

  // فرم‌های افزودن سطح3 + آیتم
  document.querySelectorAll('.add-form-with-item').forEach(form => {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('parentID', this.dataset.parent);

      submitForm('add_subcategory_item.php', formData, () => {
        this.reset(); // فرم خالی بشه
        showMessage('زیرمجموعه و آیتم جدید با موفقیت ذخیره شد', 'success');
        location.reload();
      });
    });
  });

  // فرم ویرایش سطح ۳
  document.querySelectorAll('.edit-sub3-form').forEach(form => {
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('catID', this.dataset.id);

      // اضافه کردن فایل‌ها
      this.querySelectorAll('input[type="file"]').forEach(fileInput => {
        if (fileInput.files[0]) {
          formData.append(fileInput.name, fileInput.files[0]);
        }
      });

      submitForm('edit_subcategory_item.php', formData, () => {
        showMessage('ویرایش با موفقیت انجام شد', 'success');
        location.reload();
      });
    });
  });
}

function submitForm(url, formData, onSuccess) {
  fetch(url, { method: 'POST', body: formData })
    .then(r => r.json())
    .then(data => {
      if (data.success) {
        onSuccess();
      } else {
        showMessage('خطا: ' + (data.message || 'نامشخص'), 'error');
      }
    })
    .catch(err => {
      console.error(err);
      showMessage('خطا در ارتباط با سرور', 'error');
    });
}