// تابع نمایش پیام
export function showMessage(text, type = 'success') {
  const box = document.getElementById('message-box');
  const msgText = document.getElementById('message-text');
  const closeBtn = document.getElementById('message-close');

  if (!box || !msgText || !closeBtn) return;

  msgText.textContent = text;
  box.className = 'message ' + type;
  box.classList.remove('hidden');

  closeBtn.onclick = () => box.classList.add('hidden');

  setTimeout(() => {
    if (!box.classList.contains('hidden')) {
      box.classList.add('hidden');
    }
  }, 5000);
}