<?php
include 'php/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO languages (code, name) VALUES (?, ?)");
    $stmt->execute([$_POST['code'], $_POST['name']]);
    header("Location: languages.php");
    exit;
}

$languages = $pdo->query("SELECT * FROM languages")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>مدیریت زبان‌ها</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
    <h2>📌 لیست زبان‌ها</h2>
    <table class="table table-bordered">
        <tr><th>ID</th><th>کد</th><th>نام</th></tr>
        <?php foreach ($languages as $lang): ?>
            <tr>
                <td><?= $lang['id'] ?></td>
                <td><?= $lang['code'] ?></td>
                <td><?= $lang['name'] ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

    <h3 class="mt-4">➕ افزودن زبان جدید</h3>
    <form method="POST">
        <input name="code" class="form-control mb-2" placeholder="کد زبان (مثلا fa)">
        <input name="name" class="form-control mb-2" placeholder="نام زبان (مثلا فارسی)">
        <button class="btn btn-primary">ذخیره</button>
    </form>
</body>
</html>
