<?php1
session_start();

// گرفتن زبان‌ها از دیتابیس
$stmt = $pdo->query("SELECT LanguageCode AS code, LanguageName AS name, is_default 
                     FROM Language ORDER BY LanguageCode ASC");
$languages = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ------------------- تغییر زبان فعال -------------------
if (isset($_GET['set_lang'])) {
    $code = $_GET['set_lang'];

    // همه زبان‌ها رو غیر فعال کن
    $pdo->exec("UPDATE Language SET is_default = 0");

    // زبان انتخاب‌شده رو فعال کن
    $stmt = $pdo->prepare("UPDATE Language SET is_default = 1 WHERE LanguageCode = :code");
    $stmt->execute([':code' => $code]);

    // ذخیره در سشن
    $_SESSION['lang'] = $code;

    // رفرش صفحه با زبان جدید
    header("Location: ?lang=" . urlencode($code));
    exit;
}

// ------------------- تعیین زبان جاری -------------------
$lang = $_GET['lang'] ?? $_SESSION['lang'] ?? null;

if (!$lang) {
    $stmt = $pdo->query("SELECT LanguageCode FROM Language WHERE is_default = 1 LIMIT 1");
    $lang = $stmt->fetchColumn() ?: 'fa';
}

$_SESSION['lang'] = $lang;
$default_lang = $lang;

// ------------------- جهت متن -------------------
$rtl_langs = ['fa', 'ar'];
$dir = in_array($lang, $rtl_langs) ? 'rtl' : 'ltr';

// ------------------- تغییر زبان پیش‌فرض در تنظیمات سایت -------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_default'])) {
    $newLang = $_POST['default_lang'] ?? 'fa';
    $stmt = $pdo->prepare("UPDATE SiteSettings SET setting_value = :lang WHERE setting_key = 'default_lang'");
    $stmt->execute([':lang' => $newLang]);
    echo "<div style='color:green'>✅ زبان پیش‌فرض تغییر کرد</div>";
}
?>

<!-- ================= نمایش منوی زبان ================= -->
<div class="langs">
  <?php if (!empty($languages)): ?>
      <?php foreach ($languages as $langRow): ?>
          <a href="?lang=<?= htmlspecialchars($langRow['code']) ?>" 
             class="<?= ($lang == $langRow['code'] ? 'active' : '') ?>">
             <?= htmlspecialchars($langRow['name']) ?>
          </a>
      <?php endforeach; ?>
  <?php else: ?>
      <p>هیچ زبانی ثبت نشده است.</p>
  <?php endif; ?>
</div>
