<?php
// --- اتصال به دیتابیس ---
$host = "localhost";
$db   = "tabrizli_arkbam";
$user = "tabrizli_arkbamuser";
$pass = "01478520Mi!!";
$charset = "utf8mb4";
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

$lang = $_GET['lang'] ?? 'fa';

// گرفتن متن‌ها بر اساس کد
function getMessageByCode(PDO $pdo, string $lang, string $code): ?array {
    $sql = "
        SELECT tr.Title, tr.Body
        FROM MessageTemplate mt
        JOIN MessageTemplateTranslation tr 
            ON mt.MessageID = tr.MessageID
        WHERE tr.LanguageCode = :lang
          AND mt.Code = :code
        LIMIT 1
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'lang' => $lang,
        'code' => $code
    ]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    return $row ?: null;
}

// گرفتن لوگو
$stmt = $pdo->query("SELECT FileName FROM SiteLogo ORDER BY LogoID DESC LIMIT 1");
$logo = $stmt->fetchColumn();

// گرفتن دسته‌ها
$stmt = $pdo->prepare("
    SELECT c.CategoryID, c.ParentID, c.Level, t.Name, c.SortOrder, t.Description
    FROM Category c
    JOIN CategoryTranslation t ON c.CategoryID = t.CategoryID
    WHERE t.LanguageCode = :lang
    ORDER BY c.Level, c.SortOrder
");
$stmt->execute(['lang' => $lang]);
$categories = $stmt->fetchAll(PDO::FETCH_GROUP|PDO::FETCH_UNIQUE);

// گرفتن آیتم‌ها
$stmt = $pdo->prepare("
    SELECT i.ItemID, i.CategoryID, i.Price, i.Image, t.Description
    FROM ItemDetail i
    LEFT JOIN ItemDetailTranslation t ON i.ItemID = t.ItemID AND t.LanguageCode = :lang
");
$stmt->execute(['lang' => $lang]);
$items = $stmt->fetchAll();
$itemByCategory = [];
foreach ($items as $it) {
    $itemByCategory[$it['CategoryID']][] = $it;
}
?>

  <?php
$lang = $_GET['lang'] ?? 'fa';

// تعیین فایل CSS بر اساس زبان
$cssFile = in_array($lang, ['en', 'tr']) ? 'css/ltr-arkbam-v1.css' : 'css/rtl-arkbam-v1.css';
?>
<!doctype html>
<html lang="<?= htmlspecialchars($lang) ?>" dir="<?= in_array($lang, ['en','tr']) ? 'ltr' : 'rtl' ?>">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>کافه بام ارک</title>
    <link href="css/arkbam-v1.css?>?v=2.3" rel="stylesheet">
  <link rel="stylesheet" href="<?= $cssFile ?>?v=1.0">
</head>

  
  
  <style>
    /* انیمیشن‌ها */
    .fade-in {
      opacity: 0;
      transform: translateY(20px);
      transition: all 0.6s ease;
    }
    .fade-in.visible {
      opacity: 1;
      transform: translateY(0);
    }
    /* تاخیرها */
    .delay-1 { transition-delay: 0.2s; }
    .delay-2 { transition-delay: 0.4s; }
    .delay-3 { transition-delay: 0.6s; }
    .delay-4 { transition-delay: 0.8s; }
    .delay-5 { transition-delay: 1s; }
  </style>
</head>
<body>
<main class="main-class class-custom">
    
    <div id="body-main" class="body-min-class fade-in delay-1">
            <div id="top-logo" class="top-logo-class"><img src="img/logook4.png"></div>

  <!-- Logo -->
  <div id="logo" class="logo-class fade-in delay-1">
    <?php if ($logo): ?>
      <img src="logo/<?= htmlspecialchars($logo) ?>" alt="لوگو" width="80">
    <?php endif; ?>
  </div>
  <div id="body-main-menu" class="body-min-menu fade-in delay-1">
  <!-- زبان‌ها -->
  <div class="mb-3 fade-in delay-2">
    <a href="?lang=fa">فارسی</a> |
    <a href="?lang=en">English</a> |
    <a href="?lang=tr">Türkçe</a> |
    <a href="?lang=ar">العربية</a>
  </div>

  <!-- Info text (کد 1) -->
  <div id="text-info1" class="text-info-class fade-in delay-3">
    <?= htmlspecialchars((getMessageByCode($pdo, $lang, '1')['Body'] ?? 'متنی ثبت نشده است')) ?>
  </div>

  <?php
  foreach ($categories as $catID => $cat) {
      if ($cat['Level'] == 1) {
          echo "<div class='level1 level1-{$catID} fade-in delay-1'>
                  <h4>".htmlspecialchars($cat['Name'])."</h4>";

          echo "<div class='tabs tabs-parent-{$catID} fade-in delay-2'>";
          echo "<div class='tab-buttons'>";
          foreach ($categories as $subID => $sub) {
              if ($sub['Level']==2 && $sub['ParentID']==$catID) {
                  echo "<button class='tab-btn tab-btn-{$subID} fade-in delay-3' data-tab='tab$subID'>".htmlspecialchars($sub['Name'])."</button>";
              }
          }
          echo "</div>";

          foreach ($categories as $subID => $sub) {
              if ($sub['Level']==2 && $sub['ParentID']==$catID) {
                  echo "<div id='tab$subID' class='tab-content tab-content-{$subID} fade-in delay-4'>
                          <button class='close-tab' data-target='tab$subID'>&times;</button>";
                         echo "<h5>".htmlspecialchars($sub['Name'])."</h5>";
                                           
                         echo " <div class='sub-dec'><h8>".htmlspecialchars($sub['Description'])."</h8></div>";
                                                                                 

                  foreach ($categories as $sub2ID => $sub2) {
                      if ($sub2['Level']==3 && $sub2['ParentID']==$subID) {
                          
                          if (isset($itemByCategory[$sub2ID])) {
                              echo "<ul class='item-list'>";
                              $delay = 1;
                              foreach ($itemByCategory[$sub2ID] as $it) {
                                  echo "<li class='item fade-in delay-{$delay}'>";
                                  $delay = $delay < 5 ? $delay + 1 : 1; 
                                  
                                  if (!empty($it['Image'])) {
                                      $img = htmlspecialchars($it['Image']);
                                      echo "<div class='item-left'>
                                              <img class='item-img' src='{$img}' alt=''>
                                            </div>";
                                  }

                                  echo "<div class='item-right'>
                                          <div class='item-top'>
                                            <span class='item-name'>".htmlspecialchars($sub2['Name'])."</span>
                                             <span class='price-box'>
                                            <span class='price'>".number_format($it['Price'] ?? 0)." 
    <span class='toman'>".htmlspecialchars((getMessageByCode($pdo, $lang, '3')['Body'] ?? 'هزارتومان'))."</span>                                            </span>
                                          </div>
                                          <div class='item-desc'>".htmlspecialchars($sub2['Description'] ?? '')."</div>
                                        </div>
                                        </li>";
                              }
                              echo "</ul>";
                          }
                      }
                  }
                  echo "</div>";
              }
          }
          echo "</div></div>";
      }
  }
  ?>

  <!-- Copyright -->
  <div id="text-copyright" class="text-copyright-class fade-in delay-5">
    <?= htmlspecialchars((getMessageByCode($pdo, $lang, '2')['Body'] ?? 'متنی ثبت نشده است')) ?>
  </div>
    </div>
</main>

<script>
document.addEventListener("DOMContentLoaded", () => {
  // تب‌ها
  const buttons = document.querySelectorAll(".tab-btn");
  const contents = document.querySelectorAll(".tab-content");
  const closeBtns = document.querySelectorAll(".close-tab");

  buttons.forEach(btn => {
    btn.addEventListener("click", () => {
      buttons.forEach(b => b.classList.remove("active"));
      contents.forEach(c => c.classList.remove("active"));
      btn.classList.add("active");
      document.getElementById(btn.dataset.tab).classList.add("active");
    });
  });
  

  
document.querySelectorAll('.tab-btn').forEach(btn => {
  btn.addEventListener('click', function () {
    setTimeout(() => {
      const tabContent = document.querySelector('.tab-content.active');
      if (tabContent) {
        const topPos = tabContent.getBoundingClientRect().top + window.scrollY - 100; // فاصله 100px از بالا
        window.scrollTo({
          top: topPos,
          behavior: 'smooth'
        });
      }
    }, 200);
  });
});

  
  
  
  
  

  closeBtns.forEach(close => {
    close.addEventListener("click", () => {
      const target = document.getElementById(close.dataset.target);
      if (target) target.classList.remove("active");
      buttons.forEach(b => b.classList.remove("active"));
    });
  });

  // افکت fade-in با اسکرول
  const fadeElements = document.querySelectorAll(".fade-in");
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add("visible");
        observer.unobserve(entry.target);
      }
    });
  }, { threshold: 0.1 });

  fadeElements.forEach(el => observer.observe(el));
});
</script>
</body>
</html>
