function renderList(items) {
  if (!items.length) {
    listContainer.innerHTML = '<p class="muted">هیچ عنوانی وجود ندارد.</p>';
    return;
  }

  listContainer.innerHTML = items.map(it => `
    <div class="menu-row" data-id="${it.id}">
      <div class="col title">
        <div class="show">
          <div class="fa">${escapeHtml(it.title_fa)}</div>
          <div class="en">${escapeHtml(it.title_en || '')}</div>
          <div class="tr">${escapeHtml(it.title_tr || '')}</div>
        </div>
        <div class="edit" style="display:none;">
          <input class="ef fa" value="${escapeHtml(it.title_fa)}"/>
          <input class="ef en" value="${escapeHtml(it.title_en || '')}"/>
          <input class="ef tr" value="${escapeHtml(it.title_tr || '')}"/>
        </div>
      </div>
      <div class="col actions">
        <button class="icon edit-btn"><i class="fa fa-edit"></i></button>
        <button class="icon save-btn" style="display:none;"><i class="fa fa-check"></i></button>
        <button class="icon cancel-btn" style="display:none;"><i class="fa fa-times"></i></button>
        <button class="icon delete-btn"><i class="fa fa-trash"></i></button>
      </div>
    </div>
  `).join('');

  attachRowEvents();
}
