// Import all modules
import { removeRequiredAttributes, restoreOpenTabs } from './utils.js';
import { initializeAccordions } from './accordion.js';
import { initializeModals } from './modals.js';
import { initializeFormSubmissions } from './forms.js';
import { initializeApiCalls } from './api.js';

// همه چیز را پس از لود صفحه تنظیم می‌کنیم
document.addEventListener('DOMContentLoaded', function() {
  // حذف ویژگی required از همه فیلدهای فرم
  removeRequiredAttributes();
  
  // راه‌اندازی ماژول‌ها
  initializeAccordions();
  initializeModals();
  initializeFormSubmissions();
  initializeApiCalls();
  
  // بازگرداندن تب‌های باز بعد از reload
  restoreOpenTabs();
});